/*
FitMaps 1.0
A lightweight, easy-to-use jQuery plugin for fluid width Google maps embeds. FitMaps achieves fluid width maps in your responsive web design.

The following license means:
everyone can use and modify this plugin without restriction and for free, even for commercial purposes;
the only restriction is that you in turn don't put any restrictions on the use of this code, original or modified.

== Licensing information ==
Copyright (C) 2012 Herman van der Maas, www.waywayway.nl

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
== end licensing information ==
*/

(function( $ ){
    
	$.fn.fitMaps = function( options ) {
		var settings = {
			customSelector: null,
			h: '100%',
			w: '100%'
		}
		
		if ( options ) { 
			$.extend( settings, options );
		}
		
		var div = document.createElement('div'),
		ref = document.getElementsByTagName('base')[0] || document.getElementsByTagName('script')[0];
		
		div.className = 'fit-maps-style';
		div.innerHTML = '&shy;<style>         \
			.fluid-width-map-wrapper {        \
				position: relative;           \
				width: ' + settings.w + ';    \
				height: ' + settings.h + ';   \
				padding: 0;                   \
    			margin: 0px auto;           \
			}                                 \
			\
			.fluid-width-map-wrapper iframe {  \
				width: 100%;                  \
				height: 100%;                  \
				top: 0;                       \
				left: 0;                      \
			}                                 \
			</style>';
		
		ref.parentNode.insertBefore(div,ref);

		return this.each(function(){
			var selectors = [
				"iframe[src*='maps.google']"
			];
		
			if (settings.customSelector) {
				selectors.push(settings.customSelector);
			}
			
			var $allMaps = $(this).find(selectors.join(','));
			
			$allMaps.each(function(){
				var $this = $(this);
				if ($this.parent('.fluid-width-map-wrapper').length) return;
				
				if(!$this.attr('id')){
					var mapID = 'fitmap' + Math.floor(Math.random()*999999);
					$this.attr('id', mapID);
				}
				
				$this.wrap('<div class="fluid-width-map-wrapper"></div>');
				$this.removeAttr('height').removeAttr('width');
			});
		});
		
	}
})( jQuery );